//Campbell, Jesse
//CIS 288-001 PA 4

package d_2s_cellular_automata;

import java.lang.Math;
import java.util.Arrays;

public class CA_1D2S {
    public CA_1D2S() {
        try {
            jbInit();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    byte[][] rows;
    int curRow = 0, nxtRow = 1;
    int rowSize = 50;
    int cellStates = 2;
    byte[] rules = {0, 0, 0, 1, 1, 1, 1, 0}; // rule 30 (not reversed)

    CA_1D2S(int RowSize) {
        rowSize = RowSize;
        rows = new byte[2][rowSize];
        Reset();
    }

    int GetRowSize() {
        return rowSize;
    }

    void Reset() {
        for (int i = 0; i < GetRowSize(); i++) {
            rows[curRow][i] = 0;
            rows[nxtRow][i] = 0;
        }
        rows[curRow][rowSize / 2] = 1;
    }

    void TimeStep() {
        for (int i = 1; i < GetRowSize() - 1; i++) {
            rows[nxtRow][i] = rules[(rules.length - 1) - Map(GetCurrentRow(), i)];
        }

        //int temp = curRow;
        //curRow = nxtRow;
        //nxtRow = temp;
        curRow = 1 - curRow;
        nxtRow = 1 - nxtRow;
    }

    int Map(byte[] row, int index) {
        int nhState = 0;
        int nhSize = 3;
        int n = 2; //number of states
        for (int i = 0; i < nhSize; ++i) {
            short cellState = row[index - nhSize / 2 + i];
            nhState *= n; //Shift left one base-n digit position
            nhState += (cellState % n); // Add in the next digit
        }
        return nhState;
    }

    byte[] GetCurrentRow() {
        return rows[curRow].clone();
    }

    void Rule(int rule) { //Set binary rule from integer rule
        for (int i = rules.length - 1; i >= 0; i--) {
            rules[i] = (byte) (rule % 2);
            rule = rule / 2;
        }
    }

    int Rule() { //Get binary rule from decimal rule
        int rule = 0;
        for (int i = rules.length - 1; i >= 0; i--) {
            rule += rules[i] * Math.pow(2, rules.length - 1 - i);
        }
        return rule;
    }


    private void jbInit() throws Exception {
    }
}


class Test_CA_1D2S {
    public static void main(String[] args) {
        RunTest();
    }

    static void RunTest() {
        CA_1D2S ca = new CA_1D2S(7);
        if (ca.GetRowSize() != 7) { // Test row size
            System.out.println("ca.GetRowSize()!=7");
            return;
        }

        byte[] row0 = {0, 0, 0, 1, 0, 0, 0};
        byte[] row = ca.GetCurrentRow();

        //(row.equals(row0)); not used, compares references not data.

        if (!Arrays.equals(row0, row)) { // Test Initialization
            System.out.println("! row.equals(row0)");
            return;
        }

        byte[] row1 = {0, 0, 1, 1, 1, 0, 0};
        ca.TimeStep();
        row = ca.GetCurrentRow();

        //!row.equals(row1)

        if (!Arrays.equals(row1, row)) { // Test TimeStep()
            System.out.println("! row.equals(row1)");
            return;
        }

        byte[] row2 = {0, 1, 1, 0, 0, 1, 0};
        ca.TimeStep();
        row = ca.GetCurrentRow();

        //!row.equals(row2)

        if (!Arrays.equals(row2, row)) { // Test TimeStep()
            System.out.println("! row.equals(row2)");
            return;
        }

        System.out.println("Done testing.");

    }
}


class Test_CA_1D2S_Symmetry {
    public static void main(String[] args) {
        RunTest();
    }

    static void RunTest() {
        int n = 4; // n > 1; n is the left CA cells
        CA_1D2S ca = new CA_1D2S(2 * n + 1); //number of cells must be odd
        byte[] row;
        for (int rule = 0; rule < 256; rule++) {
            ca.Rule(rule); //Sets the rule
            ca.Reset();

            boolean symmetric = true;
            for (int rows = 0; rows < 4; rows++) {
                ca.TimeStep();
                row = ca.GetCurrentRow();
                for (int cell = 0; cell <= n; cell++) {
                    //check left side for mirroring on right
                    if (!(row[cell] == row[ca.GetRowSize() - 1 - cell])) {
                        symmetric = false;
                    }
                }

            }
            if (symmetric) {
                //System.out.println(ca.Rule() + " is Symmetric.");
                //ca.Rule() gets the rule
            }
        }
        System.out.println("Done testing symmetry!");
    }
}
